/**
 * Messenger Plus! Legacy Chatlog
 *
 * @(#)Main.java
 *
 *
 * @author XP1
 * @version 1.00 2010/10/02
 */

import java.util.*;
import java.util.regex.*;
import java.text.*;
import java.io.*;

public class Main
{
    /**
     * Creates a new instance of <code>Main</code>.
     */
    public Main()
    {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args)
    {
        // TODO code application logic here

        //Random random = new Random();

        String strInput = "";

        // Sample Messenger Plus! Legacy Chatlog
        /*
            .--------------------------------------------------------------------.
            | Session Start: 26 February 2004                                    |
            | Participants:                                                      |
            |    My user name (**********@hotmail.com)                           |
            |    Recipient's user name (*******@hotmail.com)                     |
            .--------------------------------------------------------------------.
            [16:44:33] My user name: Hello there
            [16:45:02] Recipient's : hi
            [16:45:49] My user name: How are you?
            [16:46:37] Recipient's : I'm ok
            [16:46:38] Recipient's : yourself?
        */

        final String STR_SAMPLE_CHATLOG = String.format(".--------------------------------------------------------------------." + "%n" +
                "| Session Start: 26 February 2004                                    |" + "%n" +
                "| Participants:                                                      |" + "%n" +
                "|    My user name (**********@hotmail.com)                           |" + "%n" +
                "|    Recipient's user name (*******@hotmail.com)                     |" + "%n" +
                ".--------------------------------------------------------------------." + "%n" + // 6 lines of header
                "[16:44:33] My user name: Hello there" + "%n" +
                "[16:45:02] Recipient's : hi" + "%n" +
                "[16:45:49] My user name: How are you?" + "%n" +
                "[16:46:37] Recipient's : I'm ok" + "%n" +
                "[16:46:38] Recipient's : yourself?" + //"%n" +
                "");

        strInput = STR_SAMPLE_CHATLOG;

        String strHeader = "";
        String strContent = "";

        String[] strArraySplit = strInput.split("\n");
        
        ArrayList<String> alistHeader = new ArrayList<String>();
        ArrayList<String> alistContent = new ArrayList<String>();

        final int INT_LINES_IN_HEADER = 6;
        final int INT_FIRST_PARTICIPANT_LINE = 3;
        final int INT_TIMESTAMP_LENGTH = 11;

        // Add header lines into alist
        for (int i = 0; i < INT_LINES_IN_HEADER; i++)
        {
            alistHeader.add(strArraySplit[i]);
            strHeader += String.format(strArraySplit[i] + (i != (INT_LINES_IN_HEADER - 1) ? "%n" : ""));
        }

        // Add content lines into alist
        for (int i = INT_LINES_IN_HEADER; i < strArraySplit.length; i++)
        {
            alistContent.add(strArraySplit[i]);
            strContent += String.format(strArraySplit[i] + (i != (strArraySplit.length - 1) ? "%n" : ""));
        }

        printArrayList(alistHeader);

        String[][] strArrayParticipants = null;

        int intNumberOfParticipants = 0;

        Pattern patternSessionStartDate = Pattern.compile("(\\d{1,2})[ -]([\\dA-Za-z]+)[ -](\\d{2,4})"); // (?<day>\d{1,2})[ -](?<month>[\dA-Za-z]+)[ -](?<year>\d{2,4})
        Pattern patternTimestamp = Pattern.compile("[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}");
        Pattern patternHeaderContactName = Pattern.compile("(\\w.*)(?= \\()");
        Pattern patternHeaderContactEmail = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = null;

        String strSessionStartDate = null;
//        String strSessionStartYear = null;
//        String strSessionStartMonth = null;
//        String strSessionStartDay = null;
        String strSessionStartTime = null;

        // Session Start
        // line 2

        matcher = patternSessionStartDate.matcher(alistHeader.get(1));

        if (matcher.find())
        {
            strSessionStartDate = matcher.group(0);
        }
        else
        {
            System.out.println("\"Session Start\" date not found in header.");
        }

        // Source DateFormat
        DateFormat dfDayMonthYear = new SimpleDateFormat("dd MMMMM yyyy");
        DateFormat dfDayMonthYearTime = new SimpleDateFormat("dd MMMMM yyyy HH:mm:ss");
        // Target DateFormat
        DateFormat dfYearMonthDay = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat dfYearMonthDayTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        // DateFormat Timestamp
        DateFormat dfTimestamp = new SimpleDateFormat("HH:mm:ss");

        Date dateSessionStart = null;

        //System.out.println(strSessionStartDate);

        // Participants
        // lines 4 and 5
        matcher = patternHeaderContactEmail.matcher(strHeader);

        // Each email match in header represents one participant
        while (matcher.find())
        {
            intNumberOfParticipants++;
        }

        //println(intNumberOfParticipants);

        strArrayParticipants = new String[intNumberOfParticipants][2];

        // Store each participant's name and email into strArrayParticipants
        for (int i = 0; i < strArrayParticipants.length; i++)
        {
            matcher = patternHeaderContactName.matcher(alistHeader.get(INT_FIRST_PARTICIPANT_LINE + i));

            if (matcher.find())
            {
                strArrayParticipants[i][0] = matcher.group(0);
            }
            else
            {
                System.out.println("Name not found in header.");
            }

            matcher = patternHeaderContactEmail.matcher(alistHeader.get(INT_FIRST_PARTICIPANT_LINE + i));

            if ((matcher.find()) && (matcher.groupCount() > 0))
            {
                strArrayParticipants[i][1] = matcher.group(1);
            }
            else
            {
                System.out.println("Email not found in header.");
            }
        }

        // Done read first 6 lines
        // Now read content

        // Get the first timestamp, and add it to dateSessionStart
        matcher = patternTimestamp.matcher(alistContent.get(0));

        if (matcher.find())
        {
            strSessionStartTime = matcher.group(0);

            try
            {
                dateSessionStart = dfDayMonthYearTime.parse(strSessionStartDate + " " + strSessionStartTime);
                //System.out.println(dfYearMonthDayTime.format(dateSessionStart));
            }
            catch (Exception ex)
            {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
        else
        {
            System.out.println("First timestamp not found in chatlog.");
        }

        ArrayList<Date> alistContactTimestamp = new ArrayList<Date>();
        ArrayList<String> alistContactName = new ArrayList<String>();
        ArrayList<String> alistContactMessage = new ArrayList<String>();

        String[] strArrayContent = null;

        String strContactTimestamp = "";

        for (int i = 0; i < alistContent.size(); i++) // For each line
        {
            /* Store contact timestamp */

            matcher = patternTimestamp.matcher(alistContent.get(i));

            if (matcher.find())
            {
                strContactTimestamp = matcher.group(0);

                try
                {
                    Date dateTimestamp = dfTimestamp.parse(strContactTimestamp);

                    alistContactTimestamp.add(dateTimestamp);
                }
                catch (Exception ex)
                {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            }
            else
            {
                System.out.println("Timestamp not found in chatlog content line " + (i + 1) + ".");
            }

            // Split contact name and message
            strArrayContent = alistContent.get(i).substring(INT_TIMESTAMP_LENGTH).split(": ", 2);

            /* Store contact name */
            alistContactName.add(strArrayContent[0]);

            /* Store contact message */
            alistContactMessage.add(strArrayContent[1]);
        }

        String strOutput = "";
        
        //////////////////////////////// INPUT PROCESSING
        
        //File aFile = new File(fFileName);

        strOutput += "<html><head><title>Conversation with " + strArrayParticipants[1][0] + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + strArrayParticipants[0][0] + " (msn)</title></head><body><h3>Conversation with " + strArrayParticipants[1][0] + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + strArrayParticipants[0][0] + " (msn)</h3>";

        if (alistContactTimestamp.size() == alistContactName.size() && alistContactTimestamp.size() == alistContactMessage.size()) // If contact timestamp, name, and message are all matching
        {
            for (int i = 0; i < alistContactTimestamp.size(); i++)
            {
                if (strArrayParticipants[0][0].contains(alistContactName.get(i))) // local user
                {
                    strOutput += "<font color=\"#16569E\"><font size=\"2\">" + dfTimestamp.format(alistContactTimestamp.get(i)) + "</font> <b>" + alistContactName.get(i) + ":</b></font> <font sml=\"MSN\">" + alistContactMessage.get(i) + "</font><br/>";
                }
                else
                {
                    strOutput += "<font color=\"#A82F2F\"><font size=\"2\">" + dfTimestamp.format(alistContactTimestamp.get(i)) + "</font> <b>" + alistContactName.get(i) + ":</b></font> <font sml=\"MSN\"><span style=\"font-family: High Tower Text;\"><strong><span style=\"color: #ff0000;\">" + alistContactMessage.get(i) + "</span></strong></span></font><br/>";
                }
            }

            strOutput += "</body></html>";
        }
        else
        {
            System.out.println("Contact timestamp, name, and message do not match.");
        }

        //////////////////////////////// OUTPUT

        
        System.out.println();

        //System.out.println(strOutput);

        writeTextFile("", strOutput);
    }

    /**
     * Retrieve input from the user
     *
     * @return String input from user
     */
    private static String retrieveInput(String strInputText)
    {
        Scanner scannerInput = new Scanner(System.in); // Accept input from user

        System.out.print(strInputText);

        return (scannerInput.nextLine()); // Return input from user
    }

    /**
     * Omit the empty Strings from a String array
     *
     * @param strArray the array for which its empty Strings will be omitted
     * @return the new array without the empty strings
     */
    private static String[] omitEmptyStrings(String[] strArray)
    {
        ArrayList<String> alistTemporary = new ArrayList<String>();

        for (String str : strArray)
        {
            if (!str.equals(""))
            {
                alistTemporary.add(str);
            }
        }

        strArray = new String[0];

        return (alistTemporary.toArray(strArray));
    }

    /**
     * Omit the whitespace from a String array
     *
     * @param strArray the array for which its whitespace will be omitted
     * @return the new array without the whitespace
     */
    private static String[] omitWhitespace(String[] strArray)
    {
        ArrayList<String> alistTemporary = new ArrayList<String>();

        for (String str : strArray)
        {
            if (str.trim().length() != 0)
            {
                alistTemporary.add(str);
            }
        }

        strArray = new String[0];

        return (alistTemporary.toArray(strArray));
    }

    /**
     * Checks if a String is an integer
     *
     * @param strInput the String to be checked
     * @return boolean true if an integer, false if not an integer
     */
    private static boolean isInteger(String strInput)
    {
        try
        {
            Integer.parseInt(strInput); // String is a number if it can be parsed

            return (true);
        }
        catch (NumberFormatException exNumberFormat)
        {
            /*
            // Not a number
            System.out.println();
            System.out.println("You did not enter a number.");

            System.out.println();
            System.out.println("Exception:");
            exNumberFormat.printStackTrace(System.err);
            */

            return (false);
        }
        catch (Exception ex)
        {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);

            return (false);
        }
    }

    /**
     * Checks if a String is a number
     *
     * @param strInput the String to be checked
     * @return boolean true if a number, false if not a number
     */
    private static boolean isNumber(String strInput)
    {
        try
        {
            Double.parseDouble(strInput); // String is a number if it can be parsed

            return (true);
        }
        catch (NumberFormatException exNumberFormat)
        {
            /*
            // Not a number
            System.out.println();
            System.out.println("You did not enter a number.");

            System.out.println();
            System.out.println("Exception:");
            exNumberFormat.printStackTrace(System.err);
            */

            return (false);
        }
        catch (Exception ex)
        {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);

            return (false);
        }
    }

    /**
     * Prints an object's toString() value to the screen as a String using System.out.print(),
     * Used for debugging and easy value tracking
     *
     * @param objPrint the object to be printed
     */
    private static void print(Object objPrint)
    {
        System.out.print(objPrint.toString());
    }

    /**
     * Prints an object's toString() value to the screen as a String with an extra line using System.out.println(),
     * Used for debugging and easy value tracking
     *
     * @param objPrint the object to be printed
     */
    private static void println(Object objPrint)
    {
        System.out.println(objPrint.toString());
    }

    /**
     * Prints out each object in the object array parameter to screen as a String using System.out.println(),
     * Used for debugging and value tracking
     *
     * @param objArray object array to be printed
     */
    private static void printArray(Object[] objArray)
    {
        for (Object obj : objArray)
        {
            System.out.println(obj.toString());
        }
    }

    /**
     * Prints out each object in the ArrayList parameter to screen as a String using System.out.println(),
     * Used for debugging and value tracking
     *
     * @param alistArray ArrayList to be printed
     */
    private static void printArrayList(ArrayList alistArray)
    {
        for (Object obj : alistArray)
        {
            System.out.println(obj.toString());
        }
    }

    /**
     * Reads in a text file
     *
     * @param file
     * @return
     * @throws Exception
     */
    private static String readTextFile(File file) throws Exception
    {
        Scanner scanner = null;

        String strFileContent = "";

        try
        {
            scanner = new Scanner(file, "UTF-8");

            while (scanner.hasNextLine())
            {
                strFileContent += (scanner.nextLine() + String.format("%n"));
            }
        }
        catch (IOException exIO)
        {
            // Access error
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex)
        {
            // Something happened
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally
        {
            try
            {
                scanner.close();
            }
            catch (Exception ex)
            {
                // Failed to close the file
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }

        return (strFileContent);
    }

    /**
     * Writes a String to a new text file with a unique date and time in the filename
     * 
     * @param strFilename
     * @param strFileContent
     */
    private static void writeTextFile(String strFilename, String strFileContent)
    {
        // Date and Time
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh.mm.ss aa");
        Date currentDateTime = new Date();

        strFilename = "Table " + dateFormat.format(currentDateTime) + ".html";

        Writer writerTextFile = null;

        try
        {
            writerTextFile = new OutputStreamWriter(new FileOutputStream(strFilename), "UTF-8");

            writerTextFile.write(strFileContent);
        }
        catch (IOException exIO)
        {
            // Access error
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex)
        {
            // Something happened
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally
        {
            try
            {
                writerTextFile.close();
            }
            catch (Exception ex)
            {
                // Failed to close the file
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
    }
}